::--------------------------------------------------------------------------------------------------
:: WinFE Lite Builder (c) 2012-Present Colin Ramsden, All rights Reserved.
:: 
:: Must be executed on Windows 10 x64, Administrator permissions are required.
::
:: USe Windows 10 ADK 1803
::
:: Build Version: 10.0 (27/10/2020).
::
::--------------------------------------------------------------------------------------------------

cls

NET SESSION >nul 2>&1
IF %ERRORLEVEL% EQU 0 (
    ECHO Administrator PRIVILEGES Detected - Proceeding
) ELSE (
    ECHO Administrator PRIVILEGES NOT Detected - Terminating
    EXIT /B
)

IF EXIST "USB\ARM64\bootmgr.efi" (
    ECHO Not initial run - baseline files will not be copied
) ELSE (
    ECHO Initial run - baseline files will be copied
    copy "C:\Program Files (x86)\Windows Kits\10\Assessment and Deployment Kit\Windows Preinstallation Environment\arm64\Media\bootmgr.efi" USB\ARM64 /Y
    copy "C:\Program Files (x86)\Windows Kits\10\Assessment and Deployment Kit\Deployment Tools\arm64\BCDBoot\bootsect.exe" USB\ARM64\boot /Y
    copy "C:\Program Files (x86)\Windows Kits\10\Assessment and Deployment Kit\Deployment Tools\amd64\Oscdimg\etfsboot.com" USB\ARM64\boot /Y
    copy "C:\Program Files (x86)\Windows Kits\10\Assessment and Deployment Kit\Windows Preinstallation Environment\arm64\Media\Boot\boot.sdi" USB\ARM64\boot /Y
    copy "C:\Program Files (x86)\Windows Kits\10\Assessment and Deployment Kit\Windows Preinstallation Environment\amd64\Media\Boot\Fonts\*.ttf" USB\ARM64\boot\fonts /Y
    copy "C:\Program Files (x86)\Windows Kits\10\Assessment and Deployment Kit\Windows Preinstallation Environment\arm64\Media\EFI\Boot\bootaa64.efi" USB\ARM64\efi\boot /Y
    copy "C:\Program Files (x86)\Windows Kits\10\Assessment and Deployment Kit\Windows Preinstallation Environment\amd64\Media\Boot\Fonts\*.ttf" USB\ARM64\efi\microsoft\boot\fonts /Y
    copy "C:\Program Files (x86)\Windows Kits\10\Assessment and Deployment Kit\Deployment Tools\arm64\Oscdimg\efisys_noprompt.bin" USB\ARM64\efi\microsoft\boot\efisys.bin /Y

    copy "C:\Program Files (x86)\Windows Kits\10\Assessment and Deployment Kit\Deployment Tools\amd64\Oscdimg\etfsboot.com" Tools /Y
    copy "C:\Program Files (x86)\Windows Kits\10\Assessment and Deployment Kit\Deployment Tools\amd64\Oscdimg\oscdimg.exe" Tools /Y

    copy "C:\Program Files (x86)\Windows Kits\10\Assessment and Deployment Kit\Windows Preinstallation Environment\arm64\en-us\winpe.wim" ARM64 /Y

    copy "C:\Program Files (x86)\Windows Kits\10\Assessment and Deployment Kit\Windows Preinstallation Environment\arm64\WinPE_OCs\WinPE-EnhancedStorage.cab" ARM64 /Y
    copy "C:\Program Files (x86)\Windows Kits\10\Assessment and Deployment Kit\Windows Preinstallation Environment\arm64\WinPE_OCs\WinPE-Scripting.cab" ARM64 /Y
    copy "C:\Program Files (x86)\Windows Kits\10\Assessment and Deployment Kit\Windows Preinstallation Environment\arm64\WinPE_OCs\WinPE-SecureStartup.cab" ARM64 /Y
    copy "C:\Program Files (x86)\Windows Kits\10\Assessment and Deployment Kit\Windows Preinstallation Environment\arm64\WinPE_OCs\WinPE-WMI.cab" ARM64 /Y
)

rmdir /S /Q Temp

mkdir Temp
mkdir Temp\sources
mkdir Temp\mount

::--------------------------------------------------------------------------------------------------
::
:: ARM x64 Build 
::
::--------------------------------------------------------------------------------------------------

copy /Y ARM64\winpe.wim Temp\bootA64.wim

dism.exe /Mount-Wim /WimFile:Temp\bootA64.wim /index:1 /MountDir:Temp\mount
dism.exe /image:Temp\mount /Add-Package /PackagePath:ARM64\winpe-wmi.cab
dism.exe /image:Temp\mount /Add-Package /PackagePath:ARM64\winpe-scripting.cab
dism.exe /image:Temp\mount /Add-Package /PackagePath:ARM64\Winpe-securestartup.cab
dism.exe /image:Temp\mount /Add-Package /PackagePath:ARM64\Winpe-enhancedstorage.cab

mkdir Temp\mount\Windows\System32\Config\systemprofile
mkdir Temp\mount\Windows\System32\Config\systemprofile\Desktop

copy ARM64\en-us\manage-bde.exe.mui Temp\mount\windows\system32\en-us
copy ARM64\menu.exe Temp\mount\windows\system32
copy ARM64\protect.exe Temp\mount\windows\system32
copy ARM64\winpeshl.ini Temp\mount\windows\system32
copy ARM64\reset.exe Temp\mount\windows\system32
copy ARM64\advreset.exe Temp\mount\windows\system32
copy ARM64\fit.exe Temp\mount\windows\system32

copy ARM64\wallpaper.jpg Temp\mount\windows\system32

:: Load the Software and System hives.
reg load HKLM\FE_SOFTWARE Temp\Mount\Windows\System32\Config\SOFTWARE
reg load HKLM\FE_SYSTEM Temp\Mount\Windows\System32\Config\SYSTEM
reg load HKLM\FE_USER Temp\Mount\Windows\System32\Config\DEFAULT

::--------------------------------------------------------------------------------------------------
::
:: All registry changes should be inserted within the section below.
::
::--------------------------------------------------------------------------------------------------

:: Add Troy Larson's write protect keys.
reg add HKLM\FE_SYSTEM\ControlSet001\Services\partmgr\Parameters /v SanPolicy /t REG_DWORD /d 3 /f
reg add HKLM\FE_SYSTEM\ControlSet001\Services\MountMgr\ /v NoAutoMount /t REG_DWORD /d 1 /f

:: Disable TRIM on SSD's
reg add HKLM\FE_SYSTEM\ControlSet001\Services\FileSystem\ /v DisableDeleteNotification /t REG_DWORD /d 1 /f

:: Disable Dynamic Disk Support
reg add HKLM\FE_SYSTEM\ControlSet001\Services\volmgrx\ /v Start /t REG_DWORD /d 4 /f

:: Enable Folder Browser.
reg add HKLM\FE_SOFTWARE\Classes\CLSID\{AE054212-3535-4430-83ED-D501AA6680E6} /ve /t REG_SZ /d "Shell Name Space ListView" /f
reg add HKLM\FE_SOFTWARE\Classes\CLSID\{AE054212-3535-4430-83ED-D501AA6680E6}\InProcServer32 /ve /t REG_EXPAND_SZ /d "X:\Windows\system32\explorerframe.dll" /f
reg add HKLM\FE_SOFTWARE\Classes\CLSID\{AE054212-3535-4430-83ED-D501AA6680E6}\InProcServer32 /v ThreadingModel /t REG_SZ /d "Apartment" /f

:: Auto accept WPRT EULA
reg add HKLM\FE_SOFTWARE\RAM\WPRT /v EULA /t REG_DWORD /d 1 /f

:: Disable WinPE logging, just saves the RAM disk from filling with log files.
reg add HKLM\FE_SOFTWARE\Microsoft\WBEM\Tracing\WMI /v SessionEnabled /t REG_DWORD /d 0 /f

:: Add user defined wallpaper
reg add "HKLM\FE_USER\Control Panel\Desktop" /v "Wallpaper" /d "%%systemroot%%\system32\wallpaper.jpg" /t "REG_SZ" /f

::--------------------------------------------------------------------------------------------------
::
:: End of registry settings, do not change anything beyond this point.
::
::--------------------------------------------------------------------------------------------------

:: Unload the registry hives, ensure all registry settings are added before here.
reg unload HKLM\FE_SOFTWARE
reg unload HKLM\FE_SYSTEM
reg unload HKLM\FE_USER

dism.exe /Unmount-Wim /MountDir:Temp\mount\ /Commit

copy /Y Temp\bootA64.wim USB\ARM64\sources\boot.wim
Del /Q Temp\bootA64.wim
